// Print moving averages of doubles read from stdin
// Usage: mvavg windowsize
// Vaughan Pratt
// August 2011

#include <math.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

int
main(int argc, char *argv[])
{
    int ws, i;
    double *in, tot;
    if (argc != 2) {
    	printf("Usage: %s windowsize\n", argv[0]);
	exit(0);
    }
    ws = atoi(argv[1]);
    in = calloc(ws, sizeof(double));
    for (i = tot = 0; i < ws; i++) {
    	scanf("%lf", in+i);
	tot += in[i];
    }
    printf("%3d\n", (int)(tot*100/ws));
    for (i = 0; ; i = (i + 1)%ws) {
	tot -= in[i];
	if (scanf("%lf", in+i) != 1)
	    break;
	tot += in[i];
	printf("%3d\n", (int)(tot*100/ws));
    }
    return 0;
}
